/*
 *  graphicsExtra.cpp
 *  Pirates2011
 *
 *  Created by Alan Dorin on 25/03/11.
 *  Copyright 2011 __MyCompanyName__. All rights reserved.
 *
 */

// - Routines for graphics extras for generating some basic primitives (Mark, Square, Triangle)  ----


#include "SimpleVector.h"

#include <OpenGL/OpenGL.h>
#include <OpenGL/gl.h>

void drawMark(const SimpleVector& position)
{
	glPushMatrix();
	glBegin(GL_POINTS);
		position.vector_gl_v3();
	glEnd();
	glPopMatrix();
}

void drawWireSquare(const SimpleVector& position, const SimpleVector& dimensions)
{

	static SimpleVector pt[4];
	
	double halfDimensionX = dimensions.v[vX]/2.0;
	double halfDimensionY = dimensions.v[vY]/2.0;

	pt[0].set(-halfDimensionX, +halfDimensionY, 0);
	pt[1].set(+halfDimensionX, +halfDimensionY, 0);
	pt[2].set(+halfDimensionX, -halfDimensionY, 0);
	pt[3].set(-halfDimensionX, -halfDimensionY, 0);
	
	glPushMatrix();
		position.vector_gl_translate();
		// bottomFace XY
		glBegin(GL_LINE_LOOP);
			pt[0].vector_gl_v3();
			pt[3].vector_gl_v3();			
			pt[2].vector_gl_v3();
			pt[1].vector_gl_v3();
		glEnd();
	glPopMatrix();
}

void drawFillSquare(const SimpleVector& position, const SimpleVector& dimensions)
{

	static SimpleVector pt[4];
	
	double halfDimensionX = dimensions.v[vX]/2.0;
	double halfDimensionY = dimensions.v[vY]/2.0;

	pt[0].set(-halfDimensionX, +halfDimensionY, 0);
	pt[1].set(+halfDimensionX, +halfDimensionY, 0);
	pt[2].set(+halfDimensionX, -halfDimensionY, 0);
	pt[3].set(-halfDimensionX, -halfDimensionY, 0);
	
	glPushMatrix();
		position.vector_gl_translate();
		// bottomFace XY
		glBegin(GL_POLYGON);
			pt[0].vector_gl_v3();
			pt[3].vector_gl_v3();			
			pt[2].vector_gl_v3();
			pt[1].vector_gl_v3();
		glEnd();
	glPopMatrix();
}

// Routine draws an isosoles triangle with back edge positioned by backEdge Index:
// 0 - draws front vertex to the north
// 1 - draws front vertex to the east
// 2 - draws front vertex to the south
// 3 - draws front vertex to the west

void drawWireTriangle(const SimpleVector& position, const SimpleVector& dimensions, long frontVertexIndex)
{
	static SimpleVector pt[3];
	
	double halfDimensionX = dimensions.v[vX]/2.0;
	double halfDimensionY = dimensions.v[vY]/2.0;

	switch (frontVertexIndex)
	{
		case 0:
			pt[0].set(0, +halfDimensionY, 0);	// front vertex north
			pt[1].set(+halfDimensionX, -halfDimensionY, 0);
			pt[2].set(-halfDimensionX, -halfDimensionY, 0);
		break;
		case 1:
			pt[0].set(+halfDimensionX, 0, 0);	// front vertex east
			pt[1].set(-halfDimensionX, -halfDimensionY, 0);
			pt[2].set(-halfDimensionX, +halfDimensionY, 0);
		break;
		case 2:
			pt[0].set(0, -halfDimensionY, 0);	// front vertex south
			pt[1].set(-halfDimensionX, +halfDimensionY, 0);
			pt[2].set(+halfDimensionX, +halfDimensionY, 0);
		break;
		case 3:
		default:
			pt[0].set(-halfDimensionX, 0, 0);	// front vertex west
			pt[1].set(+halfDimensionX, +halfDimensionY, 0);
			pt[2].set(+halfDimensionX, -halfDimensionY, 0);
	}
	
	glPushMatrix();
		position.vector_gl_translate();
		glBegin(GL_LINE_LOOP);
			pt[0].vector_gl_v3();
			pt[1].vector_gl_v3();
			pt[2].vector_gl_v3();
		glEnd();
	glPopMatrix();
}

void drawFillTriangle(const SimpleVector& position, const SimpleVector& dimensions, long frontVertexIndex)
{
	static SimpleVector pt[3];
	
	double halfDimensionX = dimensions.v[vX]/2.0;
	double halfDimensionY = dimensions.v[vY]/2.0;

	switch (frontVertexIndex)
	{
		case 0:
			pt[0].set(0, +halfDimensionY, 0);	// front vertex north
			pt[1].set(+halfDimensionX, -halfDimensionY, 0);
			pt[2].set(-halfDimensionX, -halfDimensionY, 0);
		break;
		case 1:
			pt[0].set(+halfDimensionX, 0, 0);	// front vertex east
			pt[1].set(-halfDimensionX, -halfDimensionY, 0);
			pt[2].set(-halfDimensionX, +halfDimensionY, 0);
		break;
		case 2:
			pt[0].set(0, -halfDimensionY, 0);	// front vertex south
			pt[1].set(-halfDimensionX, +halfDimensionY, 0);
			pt[2].set(+halfDimensionX, +halfDimensionY, 0);
		break;
		case 3:
		default:
			pt[0].set(-halfDimensionX, 0, 0);	// front vertex west
			pt[1].set(+halfDimensionX, +halfDimensionY, 0);
			pt[2].set(+halfDimensionX, -halfDimensionY, 0);
	}
	
	glPushMatrix();
		position.vector_gl_translate();
		glBegin(GL_POLYGON);
			pt[0].vector_gl_v3();
			pt[1].vector_gl_v3();
			pt[2].vector_gl_v3();
		glEnd();
	glPopMatrix();
}


